#!/usr/bin/perl -slw
use strict;
use Digest::SHA qw(sha512 sha512_hex);
use Fcntl;
#use IO::Compress:Gzip qw(gzip);
$\='';

my $filename = '/home/cbiltcliffe/KMSpico_setup.exe';

my (@grid, $readSize, $chunk, $notEOF);
open my $fh, '<:raw', $filename or die $!;
my ($piece_fh, $backupPath, $shaHex, $shaHash, $zipped, $orderFile);
$backupPath = "SHAbits/";
system ("mkdir -p ".$backupPath);

open $orderFile, '>', 'piece_order.txt';
$chunk = 0;
$notEOF = 1;
while  ($notEOF)
	{
	my ($recSize, $dummy, $record);
#	$readSize = read ($fh, $recSize, 4096, $chunk * 4096);
	seek $fh, $chunk * 4096, "SEEK_SET";
	$readSize = read $fh, $recSize, 4096;
	if ($readSize < 4096)
		{
		$notEOF = 0;
	}
	$shaHash = sha512($recSize);
	$shaHex = sha512_hex($recSize);
	open ($piece_fh, ">", $backupPath.$shaHex);
#	gzip \$recSize => \$zipped;
#	print $piece_fh $zipped;
	print $piece_fh $recSize;
	close $piece_fh;
	print $orderFile $shaHex."\n";
	print "Found chunk: " . $chunk++ . " of size: " . $readSize 
		. " begins with: " . substr($recSize, 0, 10)."\n";
	print "SHA: " . $shaHex."\n";
}

