#!/usr/bin/perl

################################
##  Start all Virtualbox VMs that are currently "saved state"d.
##  By Chris Biltcliffe
##  CB Services
##  C-Box
##  Copyright Feb 24, 2014
##  All rights reserved
################################

$VMlist = `vboxmanage list vms`;

while ($VMlist =~ s/\{([0-9a-f]{8}\-[0-9a-f]{4}\-[0-9a-f]{4}\-[0-9a-f]{4}\-[0-9a-f]{12})\}//)
	{
	$VMguid = $1;
	$VMstate = &getVMstatus($VMguid);
	print "VM guid: ". $VMguid ." - State: ".$VMstate." .\n";
	if ($VMstate =~ /saved/)
		{
		&resumeVM($VMguid);
	}
}


sub getVMstatus
	{
	$VMguid = @_[0];
	$VMinfo = `vboxmanage showvminfo $VMguid`;
	@statechop = split /State\:\s{1,25}/, $VMinfo;
	$VMinfo = $statechop[1];
	@statechop2 = split /\s\(since/, $statechop[1];
	
	$VMstate = $statechop2[0];
}

sub resumeVM
	{
	$VMguid = @_[0];
	`vboxmanage startvm $VMguid`;
}
